/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.general;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.base.IVWUDDIBusinessStatusListener;
import filenet.vw.toolkit.utils.ws.base.VWUDDIBusinessItem;
import filenet.vw.toolkit.utils.ws.general.VWUDDIBusinessGeneralDescPanel;
import filenet.vw.toolkit.utils.ws.general.VWUDDIBusinessGeneralNamePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class VWUDDIBusinessGeneralPanel
extends JPanel {
    private VWUDDIBusinessItem m_vwBusinessItem = null;
    private Frame m_parentFrame = null;
    private JSplitPane m_mainPanel = null;
    private VWUDDIBusinessGeneralNamePanel m_namePanel = null;
    private VWUDDIBusinessGeneralDescPanel m_descPanel = null;
    private boolean m_bFirstTime = true;

    public VWUDDIBusinessGeneralPanel(Frame parent, VWUDDIBusinessItem businessItem) {
        try {
            this.m_parentFrame = parent;
            this.m_vwBusinessItem = businessItem;
            this.m_namePanel = new VWUDDIBusinessGeneralNamePanel(this.m_parentFrame, this.m_vwBusinessItem);
            this.m_descPanel = new VWUDDIBusinessGeneralDescPanel(this.m_parentFrame, this.m_vwBusinessItem);
            this.m_mainPanel = new JSplitPane(0, this.m_namePanel, this.m_descPanel);
            this.m_mainPanel.setToolTipText(VWResource.s_slideToAdjustView);
            this.m_mainPanel.setOneTouchExpandable(true);
            this.m_mainPanel.setDividerSize(6);
            this.m_mainPanel.setDividerLocation(0.3);
            this.setLayout(new BorderLayout(3, 3));
            this.add((Component)this.m_mainPanel, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bFirstTime) {
            this.m_bFirstTime = false;
            if (this.m_mainPanel != null) {
                this.m_mainPanel.setDividerLocation(0.3);
            }
        }
    }

    public void addBusinessStatusListener(IVWUDDIBusinessStatusListener listener) {
        this.m_namePanel.addBusinessStatusListener(listener);
        this.m_descPanel.addBusinessStatusListener(listener);
    }

    public boolean hasChanged() {
        return this.m_namePanel.hasChanged() || this.m_descPanel.hasChanged();
    }

    public void stopEditing() {
        if (this.m_namePanel != null) {
            this.m_namePanel.stopEditing();
        }
        if (this.m_descPanel != null) {
            this.m_descPanel.stopEditing();
        }
    }

    public boolean validateData() {
        return this.m_namePanel.validateData() && this.m_descPanel.validateData();
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            if (this.m_namePanel != null) {
                this.m_namePanel.stopEditing();
                bSuccess = this.m_namePanel.update();
            }
            if (bSuccess && this.m_descPanel != null) {
                this.m_descPanel.stopEditing();
                bSuccess = this.m_descPanel.update();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_errorMessage, 1);
        }
        return bSuccess;
    }

    public void updateGeneralInfo(VWUDDIBusinessItem wsBusinessEntity) {
        this.m_vwBusinessItem = wsBusinessEntity;
        this.m_namePanel.resetBusinessInfo(this.m_vwBusinessItem);
        this.m_descPanel.resetBusinessInfo(this.m_vwBusinessItem);
    }

    public void releaseResources() {
        this.removeAll();
    }
}

